class u4e_DMSB extends ScoreBoard;

#exec TEXTURE IMPORT NAME=Icon_SBelement  FILE=Textures\Icon_SBelement.bmp GROUP="Icons" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_SBelement2  FILE=Textures\Icon_SBelement2.bmp GROUP="Icons" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_SBtop  FILE=Textures\Icon_SBtop.bmp GROUP="Icons" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_SBtopbend  FILE=Textures\Icon_SBtopbend.bmp GROUP="Icons" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_SBbottom  FILE=Textures\Icon_SBbottom.bmp GROUP="Icons" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_SBbottombend  FILE=Textures\Icon_SBbottombend.bmp GROUP="Icons" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_SBbar  FILE=Textures\Icon_SBbar.bmp GROUP="Icons" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_SBbottombar  FILE=Textures\Icon_SBbottombar.bmp GROUP="Icons" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_SBtopbar  FILE=Textures\Icon_SBtopbar.bmp GROUP="Icons" MIPS=ON

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

var bool bElement,bDrawTop,bDrawBottom;	//switches to draw elements on SB
var int PlayerNotShown;

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);

	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, YL);
		Canvas.DrawText(GRI.GameEndedComments, True);
	}
	else
	{
		Canvas.SetPos(0, 0);
		DrawVictoryConditions(Canvas);
	}
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.DrawText(TGRI.GameName);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);

	if ( TGRI.FragLimit > 0  && TGRI.TimeLimit > 0 )
		{
		Canvas.DrawText(FragGoal@TGRI.FragLimit$" & "$TimeLimit@TGRI.TimeLimit$":00");
		}

	else if ( TGRI.FragLimit > 0 )
		{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
		}

	else if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawPlayerInfo(Canvas Canvas, PlayerReplicationInfo PRI, float Xpos, float Ypos, bool bCompressed)
{
	local float XL, YL, XL2, YL2, XL3, YL3;
	local Font CanvasFont;
	local bool bLocalPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;
	local float Eff;

	Eff = ( Pri.Score / (PRI.Score + PRI.Deaths)) * 100;

	if ( Eff < 0 )
		Eff = 0;

	//DrawElement:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 50;
	Canvas.DrawColor.G = 50;
	Canvas.DrawColor.B = 50;
	if (!bElement)
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 - 256, Ypos );
		Canvas.DrawTile(Texture'Icon_SBelement', 512, 64, 0, 0, 512.0, 64.0);
		bElement = True;
		}
	else
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 - 256, Ypos );
		Canvas.DrawTile(Texture'Icon_SBelement2', 512, 64, 0, 0, 512.0, 64.0);
		bElement = False;
		}
	Canvas.Style = ERenderStyle.STY_Normal;


	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	// Draw Name
	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = CyanColor;

	Canvas.StrLen(PRI.PlayerName, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Ypos + 4);
	Canvas.DrawText(PRI.PlayerName, False);

	// Draw Score/Deaths
	if ( !bLocalPlayer )
		Canvas.DrawColor = LightCyanColor;
	Canvas.StrLen("Score:"@int(PRI.Score)$", Deaths:"@int(PRI.Deaths)$", Eff:"@int(Eff)$"%", XL, YL);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 0.5 * XL, Ypos + 4 + YL);
	Canvas.DrawText("Score:"@int(PRI.Score)$", Deaths:"@int(PRI.Deaths)$", Eff:"@int(Eff)$"%", false );

//	if ( (Level.NetMode != NM_Standalone) )
//	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
		Canvas.StrLen("Test1", XL, YL);
		// Draw Time
		Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
		Canvas.TextSize( TimeString$": 999", XL3, YL3 );
		Canvas.SetPos( Canvas.ClipX * 0.5 + 260, Ypos + 6 );
		Canvas.DrawText( TimeString$":"@Time, false );

		// Draw FPH
		Canvas.TextSize( FPHString$": 999", XL2, YL2 );
		Canvas.SetPos( Canvas.ClipX * 0.5 + 260, Ypos + YL + 6 );
		Canvas.DrawText( FPHString$": "@int(60 * PRI.Score/Time), false );

		XL3 = FMax(XL3, XL2);
		// Draw Ping
		Canvas.SetPos( Canvas.ClipX * 0.5 + 260, Ypos + 2 * YL + 6);
		Canvas.DrawText( PingString$":"@PRI.Ping, false );
//	}
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float Xpos,Ypos;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	
//	if ( PlayerCount > 15 )
//		PlayerCount = FMin(PlayerCount, (Canvas.ClipY - YStart)/YL - 1);

	Ypos = 64;
	bElement = False;
	PlayerNotShown = 0;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 50;
	Canvas.DrawColor.G = 50;
	Canvas.DrawColor.B = 50;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 256, Ypos - 32 );
	Canvas.DrawTile(Texture'Icon_SBtopbend', 32, 32, 0, 0, 32.0, 32.0);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 224, Ypos - 32 );
	Canvas.DrawTile(Texture'Icon_SBtop', Canvas.ClipX * 0.5 + 224, 32, 0, 0, 16.0, 32.0);

	Canvas.SetPos( Canvas.ClipX * 0.5 + 249, Ypos - 8 );
	Canvas.DrawTile(Texture'Icon_SBtopbar', 16, 8, 0, 0, 16.0, 8.0);
	Canvas.SetPos( Canvas.ClipX * 0.5 + 265, Ypos - 8 );
	Canvas.DrawTile(Texture'Icon_SBbar', Canvas.ClipX * 0.5 - 265, 8, 0, 0, 16.0, 8.0);

	for ( I=0; I<PlayerCount; I++ )
		{
		if ( Ypos < Canvas.ClipY - 96 )
			{
			DrawPlayerInfo( Canvas, Ordered[I], Xpos, Ypos, false );
			Ypos += 64;
			}
		else
			{
			PlayerNotShown++;
			}
		}

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 50;
	Canvas.DrawColor.G = 50;
	Canvas.DrawColor.B = 50;
	Canvas.SetPos( Canvas.ClipX * 0.5 + 224, Ypos );
	Canvas.DrawTile(Texture'Icon_SBbottombend', 32, 32, 0, 0, 32.0, 32.0);
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawTile(Texture'Icon_SBbottom', Canvas.ClipX * 0.5 + 224, 32, 0, 0, 16.0, 32.0);

	Canvas.SetPos( Canvas.ClipX * 0.5 - 265, Ypos );
	Canvas.DrawTile(Texture'Icon_SBbottombar', 16, 8, 0, 0, 16.0, 8.0);
	Canvas.SetPos( 0, Ypos + 1 );
	Canvas.DrawTile(Texture'Icon_SBbar', Canvas.ClipX * 0.5 - 265, 8, 0, 0, 16.0, 8.0);
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( PlayerNotShown > 0 )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.StrLen("Players not shown:"@PlayerNotShown, XL, YL);
		Canvas.SetPos( Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 64);
		Canvas.DrawText("Players not shown:"@PlayerNotShown, false );
		}

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
}
